﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Reactive.Linq;
using System.Threading;
using System.Threading.Tasks;
using System.Xml.Linq;
using Azyobuzi.Twikoto2.Models.Twitter;
using Codeplex.OAuth;
using Livet;

namespace Azyobuzi.Twikoto2.Models
{
    internal class Model : NotifyObject
    {
        /*
         * NotifyObjectはプロパティ変更通知の仕組みを実装したオブジェクトです。
         */

        /*
         * リッチクライアントはステートフルであるため、通常のイベントの使用はメモリリークの原因になりやすくなっています。
         * Modelからイベントを発行する場合はNotificatorを使用してください。
         *
         * Notificatorはイベント代替手段です。コードスニペット lnev でCLRイベントと同時に定義できます。
         *
         * Model同士でNotificatorを使用した通知を行う場合はNotificatorHelper、
         * ViewModelへNotificatorを使用した通知を行う場合はViewModelHelperを使用して受信側の登録をしてください。
         */

        private Settings settings;
        public Settings Settings
        {
            get
            {
                return settings = settings ?? Settings.Instance;
            }
        }

        private const string ConsumerKey = "otUyZUQT0lupkH2Pnt4Zbw";
        private const string ConsumerSecret = "RwgpTjzZVXFeSOywxwVLaCViP3G68dXQCzi3xNApA";

        private AccessToken token;

        bool _IsAuthorized;

        public bool IsAuthorized
        {
            get
            { return _IsAuthorized; }
            set
            {
                if (_IsAuthorized == value)
                    return;
                _IsAuthorized = value;
                RaisePropertyChanged("IsAuthorized");
            }
        }

        public void Authorize()
        {
            ServicePointManager.Expect100Continue = false;

            if (string.IsNullOrEmpty(Settings.AccessToken) || string.IsNullOrEmpty(Settings.AccessTokenSecret))
            {
                var auth = new OAuthAuthorizer(ConsumerKey, ConsumerSecret);
                auth.GetRequestToken("https://api.twitter.com/oauth/request_token")
                    .Subscribe(_ => OnRequestPinCode(new RequestPinCodeEventArgs(auth, _.Token)));
            }
            else
            {
                token = new AccessToken(this.Settings.AccessToken, this.Settings.AccessTokenSecret);
                this.IsAuthorized = true;
            }
        }

        #region RequestPinCodeイベント
        public event EventHandler<RequestPinCodeEventArgs> RequestPinCode;
        private Notificator<RequestPinCodeEventArgs> _RequestPinCodeEvent;
        public Notificator<RequestPinCodeEventArgs> RequestPinCodeEvent
        {
            get
            {
                if (_RequestPinCodeEvent == null)
                    _RequestPinCodeEvent = new Notificator<RequestPinCodeEventArgs>();
                return _RequestPinCodeEvent;
            }
            set { _RequestPinCodeEvent = value; }
        }

        protected void OnRequestPinCode(RequestPinCodeEventArgs e)
        {
            var threadSafeHandler = Interlocked.CompareExchange(ref RequestPinCode, null, null);
            if (threadSafeHandler != null)
                threadSafeHandler(this, e);
            RequestPinCodeEvent.Raise(e);
        }
        #endregion

        public IObservable<TokenResponse<AccessToken>> EndAuthorize(RequestToken reqToken, string pin)
        {
            return new OAuthAuthorizer(ConsumerKey, ConsumerSecret)
                .GetAccessToken("https://api.twitter.com/oauth/access_token", reqToken, pin)
                .Do(_ =>
                {
                    this.token = _.Token;
                    this.Settings.AccessToken = _.Token.Key;
                    this.Settings.AccessTokenSecret = _.Token.Secret;
                    this.Settings.ScreenName = _.ExtraData["screen_name"].First();
                    this.IsAuthorized = true;
                });
        }

        public IObservable<Status> UpdateStatus(string text, string inReplyToId)
        {
            return new OAuthClient(ConsumerKey, ConsumerSecret, this.token)
                {
                    Url = "https://api.twitter.com/1/statuses/update.xml",
                    MethodType = MethodType.Post,
                    Parameters =
                    {
                        { "status", text },
                        { "in_reply_to_status_id", inReplyToId }
                    }
                }
                .GetResponseText()
                .Select(_ => new Status(XElement.Parse(_)));
        }

        private Dictionary<Query, DispatcherCollection<Status>> timelinesCache =
            new Dictionary<Query, DispatcherCollection<Status>>();

        public DispatcherCollection<Status> Timeline
        {
            get
            {
                if (this.currentQuery != null)
                {
                    if (!this.timelinesCache.ContainsKey(this.currentQuery))
                    {
                        this.timelinesCache.Add(this.currentQuery, new DispatcherCollection<Status>(DispatcherHelper.UIDispatcher));
                    }
                    return this.timelinesCache[this.currentQuery];
                }
                else
                {
                    return null;
                }
            }
        }

        private Query currentQuery;

        public Task GetTimeline(Query query)
        {
            this.currentQuery = query;
            this.RaisePropertyChanged(() => this.CanRefresh);
            this.RaisePropertyChanged(() => this.Timeline);
            return this.Refresh(1);
        }

        public Task Refresh(int page)
        {
            if (this.currentQuery == null)
                return new Task(() => { });

            var t = new Task(() =>
            {
                var timeline = this.Timeline;
                IEnumerable<Status> statuses = Enumerable.Empty<Status>();
                //TODO
                //switch (this.currentQuery.Type)
                //{
                //    case TimelineTypes.Home:
                //    case TimelineTypes.Mentions:
                //        statuses = from status in twCtx.Status
                //                   where status.Type ==
                //                         (this.currentQuery.Type == TimelineTypes.Home ?
                //                          StatusType.Home : StatusType.Mentions) &&
                //                          status.Page == page
                //                   select status;
                //        break;
                //    case TimelineTypes.List:
                //        var splited = this.currentQuery.Parameter.Split('/');
                //        statuses = (from list in twCtx.List
                //                    where list.Type == ListType.Statuses &&
                //                          list./*Owner*/ScreenName == splited[0].TrimStart('@') &&
                //                          list.ListID == splited[1] &&
                //                          list.Page == page
                //                    select list.Statuses)
                //                    .FirstOrDefault();
                //        break;
                //}

                foreach (var status in statuses.Where(status => !timeline.Contains(status)))
                    timeline.Add(status);
            });
            t.Start();
            return t;
        }

        public bool CanRefresh
        {
            get
            {
                return currentQuery != null &&
                    currentQuery.Type != TimelineTypes.None;
            }
        }

        public IObservable<string> GetListNames()
        {
            return new[] { "https://api.twitter.com/2/lists.xml", "https://api.twitter.com/2/lists/subscriptions.xml" }
                .ToObservable()
                .SelectMany(_ => new OAuthClient(ConsumerKey, ConsumerSecret, token) { Url = _ }.GetResponseText())
                .SelectMany(_ => XElement.Parse(_)
                    .Element("lists")
                    .Elements("list")
                    .Select(listElm => listElm.Element("full_name").Value)
                );
        }
    }
}
